/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.entity.ai.citizen.builder.IBuilderUndestroyable;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAISkill;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIInteract<J extends AbstractJob<?, J>, B extends AbstractBuildingWorker>
extends AbstractEntityAISkill<J, B> {
    public static final double XP_PER_BLOCK = 0.05;
    private static final double LEVEL_MODIFIER = 0.85;
    private static final int MIN_WORKING_RANGE = 12;
    private static final int ITEM_PICKUP_RANGE = 3;
    private static final int STUCK_WAIT_TICKS = 20;
    public static final float RANGE_HORIZONTAL_PICKUP = 45.0f;
    public static final float RANGE_VERTICAL_PICKUP = 3.0f;
    private int stillTicks = 0;
    private int previousIndex = 0;
    @Nullable
    private List<BlockPos> items;
    private PathResult pathResult;
    protected int pathBackupFactor = 1;

    public AbstractEntityAIInteract(@NotNull J job) {
        super(job);
        super.registerTargets(new TickingTransition[0]);
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine) {
        return this.mineBlock(blockToMine, this.worker.func_233580_cy_());
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        return this.mineBlock(blockToMine, safeStand, true, true, null);
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand, boolean damageTool, boolean getDrops, Runnable blockBreakAction) {
        BlockState curBlockState = this.world.func_180495_p(blockToMine);
        Block curBlock = curBlockState.func_177230_c();
        if (curBlock instanceof AirBlock || curBlock instanceof IBuilderUndestroyable || curBlock == Blocks.field_150357_h) {
            if (curBlockState.func_185904_a().func_76224_d()) {
                this.world.func_217377_a(blockToMine, false);
            }
            return true;
        }
        if (this.checkMiningLocation(blockToMine, safeStand)) {
            return false;
        }
        ItemStack tool = this.worker.func_184614_ca();
        if (getDrops) {
            int fortune = ItemStackUtils.getFortuneOf(tool);
            boolean silkTouch = ItemStackUtils.hasSilkTouch(tool);
            List<ItemStack> localItems = new ArrayList<ItemStack>();
            if (silkTouch && Item.func_150898_a((Block)BlockPosUtil.getBlock(this.world, blockToMine)) != null) {
                ItemStack silkItem = new ItemStack((IItemProvider)Item.func_150898_a((Block)BlockPosUtil.getBlock(this.world, blockToMine)), 1);
                localItems.add(silkItem);
            } else {
                localItems.addAll(BlockPosUtil.getBlockDrops(this.world, blockToMine, fortune, tool, (LivingEntity)this.worker));
            }
            localItems = this.increaseBlockDrops(localItems);
            for (ItemStack item : localItems) {
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(item, (IItemHandler)this.worker.getInventoryCitizen());
            }
        }
        this.triggerMinedBlock(curBlockState);
        if (blockBreakAction == null) {
            this.worker.getCitizenItemHandler().breakBlockWithToolInHand(blockToMine);
        } else {
            blockBreakAction.run();
        }
        if (tool != ItemStack.field_190927_a && damageTool) {
            tool.func_77973_b().func_77663_a(tool, this.world, (Entity)this.worker, this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(tool.func_77973_b()), true);
        }
        this.worker.getCitizenExperienceHandler().addExperience(0.05);
        this.incrementActionsDone();
        return true;
    }

    protected List<ItemStack> increaseBlockDrops(List<ItemStack> drops) {
        return drops;
    }

    protected void triggerMinedBlock(@NotNull BlockState blockToMine) {
    }

    private boolean checkMiningLocation(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        BlockState curBlock = this.world.func_180495_p(blockToMine);
        if (!this.holdEfficientTool(curBlock, blockToMine)) {
            return true;
        }
        if (this.walkToBlock(safeStand) && MathUtils.twoDimDistance(this.worker.func_233580_cy_(), safeStand) > 12.0) {
            return true;
        }
        this.currentWorkingLocation = blockToMine;
        return this.hasNotDelayed(this.getBlockMiningDelay(curBlock, blockToMine));
    }

    public int getBlockMiningDelay(@NotNull BlockState state, @NotNull BlockPos pos) {
        if (this.worker.func_184614_ca() == null) {
            return (int)state.func_185887_b((IBlockReader)this.world, pos);
        }
        return (Boolean)MineColonies.getConfig().getServer().pvp_mode.get() != false ? (Integer)MineColonies.getConfig().getServer().blockMiningDelayModifier.get() / 2 : this.calculateWorkerMiningDelay(state, pos);
    }

    private int calculateWorkerMiningDelay(@NotNull BlockState state, @NotNull BlockPos pos) {
        double reduction = 1.0 - this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BLOCK_BREAK_SPEED);
        return (int)((double)((Integer)MineColonies.getConfig().getServer().blockMiningDelayModifier.get()).intValue() * Math.pow(0.85, (double)this.getBreakSpeedLevel() / 2.0) * (double)this.world.func_180495_p(pos).func_185887_b((IBlockReader)this.world, pos) / (double)this.worker.func_184614_ca().func_77973_b().func_150893_a(this.worker.func_184614_ca(), state) * reduction);
    }

    public int getBreakSpeedLevel() {
        return this.getPrimarySkillLevel();
    }

    public void fillItemsList() {
        this.searchForItems(this.worker.func_174813_aQ().func_72321_a(45.0, 3.0, 45.0).func_72321_a(-45.0, -3.0, -45.0));
    }

    public void searchForItems(AxisAlignedBB boundingBox) {
        this.items = this.world.func_225317_b(ItemEntity.class, boundingBox).stream().filter(item -> item != null && item.func_70089_S() && (!item.getPersistentData().func_150296_c().contains("PreventRemoteMovement") || !item.getPersistentData().func_74767_n("PreventRemoteMovement"))).map(BlockPosUtil::fromEntity).collect(Collectors.toList());
    }

    public void gatherItems() {
        this.worker.func_98053_h(true);
        if (this.worker.getNavigation().func_75500_f() || this.worker.getNavigation().func_75505_d() == null) {
            BlockPos pos = this.getAndRemoveClosestItemPosition();
            this.worker.isWorkerAtSiteWithMove(pos, 3);
            return;
        }
        int currentIndex = this.worker.getNavigation().func_75505_d().func_75873_e();
        if (currentIndex != this.previousIndex) {
            this.stillTicks = 0;
            this.previousIndex = currentIndex;
            return;
        }
        ++this.stillTicks;
        if (this.stillTicks > 20) {
            this.worker.getNavigation().func_75499_g();
            if (this.items != null && !this.items.isEmpty()) {
                this.items.remove(0);
            }
        }
    }

    private BlockPos getAndRemoveClosestItemPosition() {
        int index = 0;
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < this.items.size(); ++i) {
            double tempDistance = this.items.get(i).func_177951_i((Vector3i)this.worker.func_233580_cy_());
            if (!(tempDistance < distance)) continue;
            index = i;
            distance = tempDistance;
        }
        return this.items.remove(index);
    }

    protected BlockPos findRandomPositionToWalkTo(int range) {
        return this.findRandomPositionToWalkTo(range, this.worker.func_233580_cy_());
    }

    protected BlockPos findRandomPositionToWalkTo(int range, BlockPos pos) {
        if (this.pathResult == null) {
            this.pathBackupFactor = 1;
            this.pathResult = this.getRandomNavigationPath(range, pos);
        } else if (this.pathResult.failedToReachDestination()) {
            ++this.pathBackupFactor;
            this.pathResult = this.getRandomNavigationPath(range * this.pathBackupFactor, pos);
        }
        if (this.pathResult.isPathReachingDestination()) {
            BlockPos resultPos = this.pathResult.getPath().func_75870_c().func_224759_a();
            this.pathResult = null;
            return resultPos;
        }
        if (this.pathResult.isCancelled()) {
            this.pathResult = null;
            return null;
        }
        if (this.pathBackupFactor > 10) {
            this.pathResult = null;
            return null;
        }
        return null;
    }

    protected PathResult getRandomNavigationPath(int range, BlockPos pos) {
        if (pos == null || pos == this.worker.func_233580_cy_()) {
            return this.worker.getNavigation().moveToRandomPos(range, 1.0);
        }
        return this.worker.getNavigation().moveToRandomPosAroundX(range, 1.0, pos);
    }

    public void resetGatheringItems() {
        this.items = null;
    }

    @Nullable
    public List<BlockPos> getItemsForPickUp() {
        return this.items == null ? null : new ArrayList<BlockPos>(this.items);
    }
}

